#! /usr/bin/python
#
# Utility command to mirror all (local) repositories to external
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://DNS              

import subprocess


projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-cpt',
			'ISAAC-term-convert-cvx',
			'ISAAC-term-convert-nucc',
			'ISAAC-term-convert-hl7v3',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'apache_extensions',
			'aitc_install']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

#remoteBaseURL = 'https://daniel_armbrust@bitbucket.org/daniel_armbrust/'
#remoteBaseURL = 'https://DNS:PORT
remoteBaseURL = 'https://DNS:PORT'

for project in projects:
	print("==================================")
	print("Tag/Branch Push " + project)
	git("-c", "http.sslVerify=false", "-C", project + ".git", "push", "--all",  remoteBaseURL + project + ".git")
	git("-c", "http.sslVerify=false", "-C", project + ".git", "push", "--tags",  remoteBaseURL + project + ".git")
	print("==================================")
	print("");